/*======================================================
  Book.java
  Will read in words from a .txt file and add them to a Markov object

  Methods:
  static void readIn(Markov m, String source, int numWords)
     Will read in numWords words from the file named as "source" into a 
     Markov object. If numWords is longer than the file length, the program
     will most likely crash. Also, the file should be formattted such 
     that each line of text contains exactly one word. 
     This certainly can be improved, but it gets the job done.

  static void main(String[] args)
     Creates a new markov object, reads in a series of books, 
     prints out the Markov chain and finally diplays a new paragraph
     generated from the Markov chain
     ======================================================*/


import java.io.*;
import java.util.*;

public class Book {

    public static void readIn(Markov m, String source/*, int numWords*/) {
	try {
        Scanner f = new Scanner(new File (source) );
        
	    String s1, s2, s3;
	    s1 = s2 = s3 = " ";
	    
        s1 = f.next();
        s2 = f.next();
        s3 = f.next();
        
        for(int i = 0; f.hasNext(); i++){
			m.add(s1, s2, s3);
			s1 = s2;
			s2 = s3;
	        s3 = f.next();
	    }
	}
	catch (IOException e)  {}
    }

    public static void main( String[] args ) {
	
	Markov m = new Markov();

	readIn(m, "genesis.txt"); 
	readIn(m, "psalms.txt"); 
	readIn(m, "sawyer.txt");
	readIn(m, "hamlet.txt");
	readIn(m, "iliad.txt");
	
	readIn(m, "scarlet_out.txt");
	
	//readIn(m, "tale.txt");
   // readIn(m, "AliceInWonder_out.txt");
//	readIn(m, "CatInTheHat_out.txt");
//	readIn(m,"TheGrinch_out.txt");
//
//	readIn(m, "GreenEggs_out.txt");
//	readIn(m, "OneFish_out.txt");
	

// readIn(m, "harryPotter (1)_out.txt");

//	readIn(m, "hp (2)_out.txt");
//	
	m.printStats();
	m.generate(100);
	System.out.println();
    } 
}
